$(function(){
	
	//初始化地图
	init_index_map();
	
	//初始化搜索条件的点击事件
	init_index_search();
	
	//初始化合作伙伴的效果
	init_index_partner();
	
	//模块的拖动效果
	$( ".index_container" ).sortable({
		handle:'.index_container_header',//限制排序的动作只能在item元素中的某个元素开始。
		cancel:".index_container_header>img,.index_module_noMove,.index_container_big",//图片都禁止拖动
		connectWith: ".index_container", //可放置的位置
		placeholder: "index_module_sortable", //提示的样式
		opacity: 0.5,//拖动的透明度 
		revert: true, //缓冲效果 
		stop: function(event, ui) {
			index_update_module();
		}
    });
	
	//初始化模块
	init_index_module();
	
})

//初始化模块
function init_index_module(){
	$.ajax({
		type:'post',
		url:ctx+'/result.json',
		success:function(data){
			var data = JSON.parse(data).rowSet;
			
			for(var i = 0 ;i < data.length ; i++){
				//初始化容器宽度
				var width;
				switch (data[i].width) {
				case '1':
					width='32%';
					break;
				case '2':
					width='65.5%';
					break;
				case '3':
					width='100%';
					break;
				default:
					width='32%';
					break;
				}
				
				//整体布局
				var parentContainer=$("<div></div>").css('width',width).addClass('index_module');
				var top=$("<div></div>").addClass('index_container_header');
				var context=$("<div></div>").addClass('index_module_container');
				parentContainer.append(top).append(context);
				$($('.index_container>.index_module_noMove')[0]).before(parentContainer);
				//top头部布局
				top.append('<label class='+ data[i].ICON_CSS +'></label>');
				top.append('<span style="margin-right:5px;">'+data[i].TITLE+'</span>');
				top.append('<span>'+data[i].ENG_TITLE+'</span>');
				top.append('<img src="'+ctx+'/custom/images/index4_sectionover.png" width="17" height="17" onclick="index_module_remove(this)">');
				top.append('<img src="'+ctx+'/custom/images/index4_sectionbig.png" width="17" height="17" onclick="index_changeBig_calendar(this)">');
				top.append('<img src="'+ctx+'/custom/images/index4_sectionsmall.png" width="17" height="17" onclick="index_module_toggle(this)">');
				
				//正文填充
					
				switch (data[i].P_TYPE) {
				case '0':
					//手工录入
					console.log(手工录入)
					break;
				case '1':
					//单点集成
					//添加加载时的效果
					context.append($.jfbrother.loadStyle());
					var iframe = $('<iframe src="'+ data[i].URL +'" frameborder="0" width="100%" height="100%" ></iframe>');
					context.append(iframe);

					//iframe加载完之后的处理
					ifame_isLoad(iframe);
					
					break;
				case '3':
					//RSS订阅
					//添加加载时的效果
					context.append($.jfbrother.loadStyle());
					$.jfbrother.readRSS(data[i].URL,context,function(rss,context){
						//去掉加载时的效果
						context.html('');
						var item = rss.rss.channel.item; 
						var itemContainer = $('<div class="index_container_two_right_text"></div>');
						for(var i = 0 ; i<item.length;i++){
							var itemDiv = $('<div></div>').data('item',item[i]).bind('click',function(){
								//1.弹出框
								$.fancybox.open({href:$(this).data('item').link,type: 'iframe','width':$('.index_container').width()});
								//2.新页面
								//window.open(item[i].link);
							});
							itemDiv.hover(function(){
								$(this).find('label').stop().animate({'marginRight':'0'});
							},function(){
								$(this).find('label').stop().animate({'marginRight':'10px'});
							})
							var itemTitle=$('<span></span>').text(item[i].title);
							var itemImg = $('<label></label>').text('<');
							itemDiv.append(itemImg).append(itemTitle)
							itemContainer.append(itemDiv);
						}
						context.append(itemContainer)
					});
					
					break;
				case '4':
					//模拟登录
					//1.先做登录
					
					//2.再请求一个iframe
					var iframe = $('<iframe src="'+ data[i].URL +'" frameborder="0" width="100%" height="100%" ></iframe>');
					context.append(iframe);
					break;
				case '5':
					//内容发布
					context.append(data[i].TAKE_CONTENT);
					break;
				default:
					console.log('default')
					break;
				}
				
                //context.load(data[i].url+'?uniqueKey='+data[i].uniqueKey);
				
				//绑定数据
				parentContainer.data('data',data[i]);
			}
			//结束
		}
	})
	/*var data = [
	      {
	    	  'icon':'icon-save',
	    	  'width':'1',
	    	  'title':'办事大厅',
	    	  'englishTitle':'office hall',
	    	  'url':'/jfV5portal/jfcas04/portal/office.jsp', 
    		  uuid:'02f845bc-566c-408b-ace5-ecebb728bed1',
    		  type:'1'
	      },
	      {
	    	  'icon':'icon-help',
	    	  'width':'1',
	    	  'title':'消息中心',
	    	  'englishTitle':'Information Center',
	    	  'url':'/jfV5portal/jfcas04/portal/information.jsp',
	    	  uuid:'02f845bc-566c-408b-ace5-ecebb728bed2',
	    	  type:'2'
	      },
	      {
	    	  'icon':'icon-tip',
	    	  'width':'1',
	    	  'title':'员工信息',
	    	  'englishTitle':'Employee information',
	    	  'url':'portal/employee.jsp',
	    	  uuid:'02f845bc-566c-408b-ace5-ecebb728bed3',
	    	  type:'3'
	      },
	      {
	    	  'icon':'icon-large-chart',
	    	  'width':'2',
	    	  'title':'分析中心',
	    	  uuid:'02f845bc-566c-408b-ace5-ecebb728bed4',
	    	  'englishTitle':'Analytic center',
	    	  'url':'portal/analytic.jsp',
	    	  type:'4'
	      },
	      {
	    	  'icon':'icon-filter',
	    	  'width':'1',
	    	  'title':'新闻资讯',
	    	  'englishTitle':'News and information',
	    	  'url':'portal/news.jsp',
    		  uuid:'02f845bc-566c-408b-ace5-ecebb728bed5',
    		  type:'5'
	      }
    ];*/
	
	/*for(var i = 0 ;i < data.length ; i++){
		data[i].uniqueKey= "uuid"+data[i].uuid.replace(/-/g,'');
	}*/
	
}

//初始化合作伙伴的效果
function init_index_partner(){
	$('.index_container_partner_text img').hover(function(){
		var src = $(this).attr('src');
		var index = src.lastIndexOf("_");
		$(this).attr('src',src.substring(0, index)+'.jpg');
	},function(){
		var src = $(this).attr('src');
		var index = src.lastIndexOf(".");
		$(this).attr('src',src.substring(0, index)+'_gray.jpg');
	})
}

function init_index_search(){
	//搜索的效果
	$('.index_search_show_content span').unbind("click").bind('click',function(){
		if($(this).attr('class')=='index_search_show_result_click'){
			return;
		}	
		var index = $('.index_search_show_content span').index($(this));
		/*var oldIndex = $('.index_search_show_content span').index($(this).parent().find('.index_search_show_result_click'));
		$(this).parent().find('.index_search_show_result_click').removeClass('index_search_show_result_click');*/
		$(this).addClass('index_search_show_result_click');
		$(this).data('id',index);
		/*//先删除之前选中的
		$('#index_search_show_result>div').each(function(index,element){
			if($(element).data('id')==oldIndex){
				$(element).remove();
			}
		})*/
		//添加到搜索结果中
		var $div = $('<div class="index_search_show_result_content"><span>'+ $(this).text() +'</span><span onclick="index_search_show_result_remove(this)"><img src="'+ctx+'/custom/images/search_turn off.png" width="10" height="10" /></span></div>');
		$div.data('id',index);
		$('#index_search_show_result').append($div);
		animate_autoHeight($('.index_search_content'));
	})
}
//初始化地图
function init_index_map(){
	/*var map = new BMap.Map("index_map");
	map.centerAndZoom(new BMap.Point(116.404, 39.915), 11);
	map.addControl(new BMap.MapTypeControl({mapTypes: [BMAP_NORMAL_MAP,BMAP_HYBRID_MAP]}));     //2D图，卫星图    右上角
	map.addControl(new BMap.MapTypeControl({anchor: BMAP_ANCHOR_TOP_LEFT}));    //左上角，默认地图控件
	map.setCurrentCity("北京");   //由于有3D图，需要设置城市哦   ,目前支持北京、上海、广州、深圳4个城市3D图*/	

	//地图信息
	var map = new BMap.Map("index_map");
	var geolocation = new BMap.Geolocation();
	geolocation.getCurrentPosition(function(r){
		if(this.getStatus() == BMAP_STATUS_SUCCESS){
			var mk = new BMap.Marker(r.point);
			map.addOverlay(mk);
			/*map.panTo(r.point);//地图中心点移到当前位置*/  		
			/*alert('您的位置：'+r.point.lng+','+r.point.lat);*/
			var point = new BMap.Point(r.point.lng,r.point.lat);
			map.centerAndZoom(point,12);
			/*map.enableScrollWheelZoom(true);     //开启鼠标滚轮缩放*/

			// 创建地理编码实例      
			var myGeo = new BMap.Geocoder();      
			// 根据坐标得到地址描述    
			myGeo.getLocation(point, function(result){      
			    if (result){    
			    	var opts = {    
					    /*width : 80,     // 信息窗口宽度    
					    height: 50,     // 信息窗口高度    */
					    title : "您所在的位置:",  // 信息窗口标题
					    height:80
					}  
					//创建信息窗口对象   
			    	if(result.addressComponents.province==result.addressComponents.city){
			    		var infoWindow = new BMap.InfoWindow(result.addressComponents.province + " - " + result.addressComponents.district +"<div style='float:right;margin-top:30px;color:#1887f6' class='index_map_more'><a href='javascript:window.open(\"http://www.edushi.com/mapcity.html\")'>查看三维地图详情</a></div>", opts);
			    	}
			    	else{
			    		var infoWindow = new BMap.InfoWindow(result.addressComponents.province + " - " + result.addressComponents.city + " - " + result.addressComponents.district +"<div style='float:right;margin-top:30px;color:#1887f6' class='index_map_more'><a href='javascript:window.open(\"http://www.edushi.com/mapcity.html\")'>查看三维地图详情</a></div>", opts);
			    	}
			    	
			    	//map.addControl(new BMap.NavigationControl());  //左上角移动控件
					map.addControl(new BMap.ScaleControl());       //左下角标尺控件
					map.addControl(new BMap.OverviewMapControl()); //右下角缩略地图，注意观察，不然看不到
					map.addControl(new BMap.MapTypeControl({mapTypes: [BMAP_NORMAL_MAP,BMAP_HYBRID_MAP]}));     //右上角  地图控件
					
					if(result.addressComponents.city=="北京市"||result.addressComponents.city=="上海市"||result.addressComponents.city=="广州市"||result.addressComponents.city=="深圳市"){
						map.addControl(new BMap.MapTypeControl({anchor: BMAP_ANCHOR_TOP_LEFT}));    //左上角 地图控件	
						map.setCurrentCity(result.addressComponents.city);   //由于有3D图，需要设置城市哦   ,目前支持北京、上海、广州、深圳4个城市3D图
					}
					else{
						map.addControl(new BMap.MapTypeControl({anchor: BMAP_ANCHOR_TOP_LEFT,mapTypes: [BMAP_NORMAL_MAP,BMAP_SATELLITE_MAP,BMAP_HYBRID_MAP]}));    //左上角 地图控件
					}
			    	
					//打开信息窗口
					map.openInfoWindow(infoWindow, map.getCenter());           
			    }      
			});

		}
		else {
			alert('failed'+this.getStatus());
		}        
	});
	
	//地图加载完毕时
	map.addEventListener("tilesloaded",function(){
		$('#index_map').prev().fadeOut();
		
		//修改信息窗口样式
		$('.index_map_more').hover(function(){
			$(this).css('borderBottom','1px solid #1887f6');
		},function(){
			$(this).css('borderBottom','0');
		})
		$('.BMap_bubble_title').css({'fontWeight':'bold','fontSize':'16px','marginBottom':'10px'});
	});
}

//点击搜索时
function index_search(handler){
	$('.index_search_content>input').val('');
	var $obj = $(handler).parent(); 
	$obj.css({"background":"white"});
	animate_autoHeight($obj);
}	

//animate 自适应容器的高度
function animate_autoHeight(handler){
	var $obj = $(handler); 
	var currentHeight = $obj.css("height");
	$obj.css({"height":"auto"});
	var animateHeight = $obj.css("height");
	$obj.css("height", currentHeight);
	$obj.animate({height: animateHeight});
}

//删除查询条件
function index_search_show_result_remove(handler){
	var oldIndex = $(handler).parent().data('id');
	$(handler).parent().remove();
	animate_autoHeight($('.index_search_content'));
	$('.index_search_show_content span').each(function(index,element){
		if($(element).data('id')==oldIndex){
			$(element).removeClass('index_search_show_result_click');
		}
	})
}

//点击取消时
function index_search_show_result_close(){
	$('.index_search_content').animate({height:'48px'},function(){
		if($('.index_search_content>input').val()==''){
			$('.index_search_content>input').val('大数据搜索引擎');
		}
	});
}

//模块隐藏的效果
function index_hide_active(selectedEffect, handler, callback) {
	// 从中获取特效类型
	var selectedEffect = selectedEffect;

	// 大多数的特效类型默认不需要传递选项
	var options = {};
	// 一些特效带有必需的参数
	if (selectedEffect === "scale") {
		options = {
			percent : 0
		};
	} else if (selectedEffect === "size") {
		options = {
			to : {
				width : 200,
				height : 60
			}
		};
	}

	if (typeof callback == 'function') {
		// 运行特效
		$(handler).hide(selectedEffect, options, 1000, callback);
	} else {
		// 运行特效
		$(handler).hide(selectedEffect, options, 1000);
	}
}

//模块显示的效果
function index_show_active(selectedEffect, handler, callback) {
	// 从中获取特效类型
	var selectedEffect = selectedEffect;

	// 大多数的特效类型默认不需要传递选项
	var options = {};
	// 一些特效带有必需的参数
	if (selectedEffect === "scale") {
		options = {
			percent : 100
		};
	} else if (selectedEffect === "size") {
		options = {
			to : {
				width : 280,
				height : 185
			}
		};
	}

	if (typeof callback == 'function') {
		// 运行特效
		$(handler).show(selectedEffect, options, 500, callback);
	} else {
		// 运行特效
		$(handler).show(selectedEffect, options, 500);
	}
}

//伸缩模块
function index_module_toggle(handler){
	if($(handler).parent().nextAll().is(":animated")){
		return;
	}	
	if($(handler).attr('src')==ctx+'/custom/images/index4_sectionsmall.png'){
		$(handler).attr('src',ctx+'/custom/images/index4_sectionlarge.png');
		//隐藏变大功能
		$(handler).prev().remove();
	}
	else{
		$(handler).attr('src',ctx+'/custom/images/index4_sectionsmall.png');
		//显示变大功能
		$(handler).before('<img src="'+ctx+'/custom/images/index4_sectionbig.png" width="17" height="17" onclick="index_changeBig_calendar(this)">');
	}
	$(handler).parent().nextAll().slideToggle();
}

//删除模块
function index_module_remove(handler){
	var txt=  "是否要删除该板块!!!";
	var option = {
		title: "删除提示",
		onOk: function(){
			index_hide_active('shake',$(handler).parent().parent(),function(){
				$(handler).parent().parent().remove();
				index_update_module();
				//出现新增模块提示
				$('.index_insert_module').fadeIn();
			});
		},
		onCancel:function(){
			
		}
	}
	window.wxc.xcConfirm(txt, window.wxc.xcConfirm.typeEnum.warning,option);
}

//修改左中右模块到数据库
function index_update_module(){

	console.log(1)
	
}

//放大功能
function index_changeBig_calendar(handler){
	//先判断下其他模块有没有放大
	if($('.index_container_big').length!=0){
		$('.index_container_big').find('.index_container_header>img').click()
	}
	var data = $(handler).parents('.index_module').data('data');
	$(handler).parents('.index_module').css({'top':$(handler).offset().top-14,'width':$('.index_container').outerWidth(),'left':$('.index_container').offset().left});
	$(handler).parents('.index_module').addClass('index_container_big');
	var $imgParent = $(handler).parent();
	$imgParent.find('img').remove();
	$imgParent.append('<img src="'+ ctx +'/custom/images/index4_sectionsmall.png" style="display:block;" width="17" height="17" onclick="index_changeSmall_calendar(this)">');
	$imgParent.next().css({'maxHeight':'500px','height':'auto'});
	switch (data.width) {
	case "1":
		$imgParent.parent().data("width", "32%");
		break;
	case "2":
		$imgParent.parent().data("width", "65.5%");
		break;
	case "3":
		$imgParent.parent().data("width", "100%");
		break;
	default:
		$imgParent.parent().data("width", "32%");
		break;
	}	
}

//缩小功能
function index_changeSmall_calendar(handler){
	$(handler).parents('.index_module').css({'width':$(handler).parents('.index_module').data('width')});
	$(handler).parents('.index_module').removeClass('index_container_big');
	var $imgParent = $(handler).parent();
	$imgParent.find('img').remove();
	$imgParent.append('<img src="'+ctx+'/custom/images/index4_sectionover.png" width="17" height="17" onclick="index_module_remove(this)" /><img src="'+ctx+'/custom/images/index4_sectionbig.png" width="17" height="17" onclick="index_changeBig_calendar(this)" /><img src="'+ctx+'/custom/images/index4_sectionsmall.png" width="17" height="17" onclick="index_module_toggle(this)" />');
	$imgParent.next().css({'maxHeight':'315px','height':'315px'});
}

//判断ifame是否加载完成,参数jquery的iframe对象
function ifame_isLoad(iframe){
	if(iframe[0].attachEvent){
		//ie浏览器
		iframe[0].attachEvent("onreadystatechange", function() {
			//此事件在内容没有被载入时候也会被触发，所以我们要判断状态
			//有时候会比较怪异 readyState状态会跳过 complete 所以我们loaded状态也要判断
			if (iframe[0].readyState === "complete" || iframe[0].readyState == "loaded") {
				//代码能执行到这里说明已经载入成功完毕了
				//要清除掉事件
				iframe.prev().remove();
				iframe[0].detachEvent("onreadystatechange", arguments.callee);
				//这里是回调函数
			}
		});
	}
	else{
		//其他浏览器（Firefox,Opera,chrome等 ）
		iframe[0].addEventListener("load", function() {
			//代码能执行到这里说明已经载入成功完毕了
			this.removeEventListener("load", arguments.call, false);
			//这里是回调函数
			iframe.prev().remove();
		}, false);
	}
}
