/*jslint browser: true */ /*global jQuery: true */

/**
 * jQuery Cookie plugin
 *
 * Copyright (c) 2010 Klaus Hartl (stilbuero.de)
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 *
 */

// TODO JsDoc

/**
 * Create a cookie with the given key and value and other optional parameters.
 *
 * @example $.cookie('the_cookie', 'the_value');
 * @desc Set the value of a cookie.
 * @example $.cookie('the_cookie', 'the_value', { expires: 7, path: '/', domain: 'jquery.com', secure: true });
 * @desc Create a cookie with all available options.
 * @example $.cookie('the_cookie', 'the_value');
 * @desc Create a session cookie.
 * @example $.cookie('the_cookie', null);
 * @desc Delete a cookie by passing null as value. Keep in mind that you have to use the same path and domain
 *       used when the cookie was set.
 *
 * @param String key The key of the cookie.
 * @param String value The value of the cookie.
 * @param Object options An object literal containing key/value pairs to provide optional cookie attributes.
 * @option Number|Date expires Either an integer specifying the expiration date from now on in days or a Date object.
 *                             If a negative value is specified (e.g. a date in the past), the cookie will be deleted.
 *                             If set to null or omitted, the cookie will be a session cookie and will not be retained
 *                             when the the browser exits.
 * @option String path The value of the path atribute of the cookie (default: path of page that created the cookie).
 * @option String domain The value of the domain attribute of the cookie (default: domain of page that created the cookie).
 * @option Boolean secure If true, the secure attribute of the cookie will be set and the cookie transmission will
 *                        require a secure protocol (like HTTPS).
 * @type undefined
 *
 * @name $.cookie
 * @cat Plugins/Cookie
 * @author Klaus Hartl/klaus.hartl@stilbuero.de
 */

/**
 * Get the value of a cookie with the given key.
 *
 * @example $.cookie('the_cookie');
 * @desc Get the value of a cookie.
 *
 * @param String key The key of the cookie.
 * @return The value of the cookie.
 * @type String
 *
 * @name $.cookie
 * @cat Plugins/Cookie
 * @author Klaus Hartl/klaus.hartl@stilbuero.de
 */
jQuery.cookie = function (key, value, options) {

    // key and value given, set cookie...
    if (arguments.length > 1 && (value === null || typeof value !== "object")) {
        options = jQuery.extend({}, options);

        if (value === null) {
            options.expires = -1;
        }

        if (typeof options.expires === 'number') {
            var days = options.expires, t = options.expires = new Date();
            t.setDate(t.getDate() + days);
        }

        return (document.cookie = [
            encodeURIComponent(key), '=',
            options.raw ? String(value) : encodeURIComponent(String(value)),
            options.expires ? '; expires=' + options.expires.toUTCString() : '', // use expires attribute, max-age is not supported by IE
            options.path ? '; path=' + options.path : '',
            options.domain ? '; domain=' + options.domain : '',
            options.secure ? '; secure' : ''
        ].join(''));
    }

    // key and possibly options given, get cookie...
    options = value || {};
    var result, decode = options.raw ? function (s) { return s; } : decodeURIComponent;
    return (result = new RegExp('(?:^|; )' + encodeURIComponent(key) + '=([^;]*)').exec(document.cookie)) ? decode(result[1]) : null;
};

var BASE64={ 
	    /** 
	     * 此变量为编码的key，每个字符的下标相对应于它所代表的编码。 
	     */ 
	    enKey: 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/', 
	    /** 
	     * 此变量为解码的key，是一个数组，BASE64的字符的ASCII值做下标，所对应的就是该字符所代表的编码值。 
	     */ 
	    deKey: new Array( 
	        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	        -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 
	        52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, 
	        -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
	        15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, 
	        -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 
	        41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1 
	    ), 
	    /** 
	     * 编码 
	     */ 
	    encode: function(src){ 
	    	// 为null时转为空串;
	    	src = src || "";
	        //用一个数组来存放编码后的字符，效率比用字符串相加高很多。 
	        var str=new Array(); 
	        var ch1, ch2, ch3; 
	        var pos=0; 
	       //每三个字符进行编码。 
	        while(pos+3<=src.length){ 
	            ch1=src.charCodeAt(pos++); 
	            ch2=src.charCodeAt(pos++); 
	            ch3=src.charCodeAt(pos++); 
	            str.push(this.enKey.charAt(ch1>>2), this.enKey.charAt(((ch1<<4)+(ch2>>4))&0x3f));
	            str.push(this.enKey.charAt(((ch2<<2)+(ch3>>6))&0x3f), this.enKey.charAt(ch3&0x3f));
	         } 
	        //给剩下的字符进行编码。 
	        if(pos<src.length){ 
	            ch1=src.charCodeAt(pos++); 
	            str.push(this.enKey.charAt(ch1>>2)); 
	            if(pos<src.length){ 
	                ch2=src.charCodeAt(pos); 
	                str.push(this.enKey.charAt(((ch1<<4)+(ch2>>4))&0x3f)); 
	                str.push(this.enKey.charAt(ch2<<2&0x3f), '='); 
	            }else{ 
	                str.push(this.enKey.charAt(ch1<<4&0x3f), '=='); 
	            } 
	        } 
	       //组合各编码后的字符，连成一个字符串。 
	        return str.join(''); 
	    }, 
	    /** 
	     * 解码。 
	     */ 
	    decode: function(src){ 
	        //用一个数组来存放解码后的字符。 
	        var str=new Array(); 
	        var ch1, ch2, ch3, ch4; 
	        var pos=0; 
	       //过滤非法字符，并去掉'='。 
	        src=src.replace(/[^A-Za-z0-9\+\/]/g, ''); 
	        //decode the source string in partition of per four characters. 
	        while(pos+4<=src.length){ 
	            ch1=this.deKey[src.charCodeAt(pos++)]; 
	            ch2=this.deKey[src.charCodeAt(pos++)]; 
	            ch3=this.deKey[src.charCodeAt(pos++)]; 
	            ch4=this.deKey[src.charCodeAt(pos++)]; 
	            str.push(String.fromCharCode( 
	                (ch1<<2&0xff)+(ch2>>4), (ch2<<4&0xff)+(ch3>>2), (ch3<<6&0xff)+ch4));
	         } 
	        //给剩下的字符进行解码。 
	        if(pos+1<src.length){ 
	            ch1=this.deKey[src.charCodeAt(pos++)]; 
	            ch2=this.deKey[src.charCodeAt(pos++)]; 
	            if(pos<src.length){ 
	                ch3=this.deKey[src.charCodeAt(pos)]; 
	                str.push(String.fromCharCode((ch1<<2&0xff)+(ch2>>4), (ch2<<4&0xff)+(ch3>>2)));
	             }else{ 
	                str.push(String.fromCharCode((ch1<<2&0xff)+(ch2>>4))); 
	            } 
	        } 
	       //组合各解码后的字符，连成一个字符串。 
	        return str.join(''); 
	    } 
	}; 
