package com.jw.app.business.portlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.PortletBusiness;
import com.jw.app.business.utils.QueryParamUtil;

public class PortletBusinessImpl implements PortletBusiness {
	
	private PortletDAO portletDAO;	

	public PortletDAO getPortletDAO() {
		return portletDAO;
	}

	public void setPortletDAO(PortletDAO portletDAO) {
		this.portletDAO = portletDAO;
	}

	
	@Override
	public List<Map<String, Object>> list_portlet_template_by_user(Map<String, Object> query)
			throws BusinessException {
		List<Map<String, Object>> listData=null;
		try {
			listData = QueryParamUtil.ClobToString(portletDAO.list_portlet_template_user(query));
			if(listData.size()==0){
				//如果当前登陆人还没有设置自定义的资源，则显示默认的资源
				query.put("USER_ID", "default");
				listData = QueryParamUtil.ClobToString(portletDAO.list_portlet_template_user(query));
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return listData;
	}

}
