package com.gaowj.business;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;

/**
 * 标准代码库业务接口
 * 
 * @author 高伟杰
 * @time 2014-12-03
 */
@Service
public interface StandardBusiness {
	/**
     * 查找所有代码表 
     * 
     * @return
     */
    Page<Map<String, Object>> list_all_tables(int pageNo, int pageSize,Map<String, Object> query)throws BusinessException;

    List<Map<String, Object>> list_all_tables(Map<String, Object> query)throws BusinessException;
    /**
     * 查找所有代码表总数
     * 
     * @return
     */
    int list_all_tables_count(Map<String, Object> query)throws BusinessException;
    /**
     * 查找所有代码表字段 
     * 
     * @return
     */
    Page<Map<String, Object>> list_all_columns(int pageNo, int pageSize,Map<String, Object> query)throws BusinessException;

    List<Map<String, Object>> list_all_columns(Map<String, Object> query)throws BusinessException;
    /**
     * 查找所有代码表字段总数
     * 
     * @return
     */
    int list_all_columns_count(Map<String, Object> query)throws BusinessException;
	/**
     * 动态查询 表的数据总数（TAG_DELETE = '0'） 
     * 
     * @return
     */
    Page<Map<String, Object>> list_tables_info(int pageNo, int pageSize,Map<String, Object> query)throws BusinessException;

    List<Map<String, Object>> list_tables_info(Map<String, Object> query)throws BusinessException;
    /**
     * 动态查询 表的数据总数（TAG_DELETE = '0'） 
     * 
     * @return
     */
    int list_tables_info_count(Map<String, Object> query)throws BusinessException;

    /**
     * 删除 
     * 
     * @return
     */
    void delete_tables_info(Map<String, Object> entity) throws BusinessException;

    /**
     * 插入 
     * 
     * @return
     */
    void insert_tables_info(Map<String, Object> entity) throws BusinessException;



    /**
     * 修改
     * @param entity
     * @return
     * @throws BusinessException
     */
    void update_tables_info(Map<String, Object> entity) throws BusinessException;
    
    /**
     * 动态查询 表的数据总数
     * 
     * @return
     */
    Page<Map<String, Object>> list_tables(int pageNo, int pageSize,Map<String, Object> query)throws BusinessException;

    List<Map<String, Object>> list_tables(Map<String, Object> query)throws BusinessException;
    /**
     * 动态查询 表的数据总数 
     * 
     * @return
     */
    int list_tables_count(Map<String, Object> query)throws BusinessException;
    
    /**
     * 查找所有代码表放入缓存
     * 
     * @return
     */
    void insert2Cache() throws BusinessException;
    /**
     * 从缓存获取一张表所有记录
     * 
     * @return
     */
    List<Map<String, Object>> list_tables_info_cache(Map<String, Object> query)throws BusinessException;
    /**
     * 更新缓存一张表所有记录
     * 
     * @return
     */
    public void updateCache(Map<String, Object> query)throws BusinessException;
}
