package com.gaowj.business.standard;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.RowBounds;
//import org.springframework.cache.annotation.Cacheable;

import com.gaowj.business.exception.BusinessException;

public interface StandardDAO {
	

	/**
     * 找所有代码表
     * 
     * @param tokenId
     * @param tableName
     * @return
     */
//	@Cacheable(value="ehcache1",key="'SystemOpeBusiness.listLog4jInfo'")
    List<Map<String, Object>> list_all_tables(RowBounds rbonds,Map<String, Object> query) throws BusinessException;
    
    List<Map<String, Object>> list_all_tables(Map<String, Object> query) throws BusinessException;

    /**
     * 找所有代码表总数
     * 
     * @return
     */
    int list_all_tables_count(Map<String, Object> query) throws BusinessException;
    
    /**
     * 找所有代码表字段
     * 
     * @param tokenId
     * @param tableName
     * @return
     */
    List<Map<String, Object>> list_all_columns(RowBounds rbonds,Map<String, Object> query) throws BusinessException;
    
    List<Map<String, Object>> list_all_columns(Map<String, Object> query) throws BusinessException;

    /**
     * 找所有代码表字段总数
     * 
     * @return
     */
    int list_all_columns_count(Map<String, Object> query) throws BusinessException;
    
	/**
     * 动态查询有效记录（TAG_DELETE = '0'） 
     * 
     * @param tokenId
     * @param tableName
     * @return
     */
    List<Map<String, Object>> list_tables_info(RowBounds rbonds,Map<String, Object> query) throws BusinessException;
    
    List<Map<String, Object>> list_tables_info(Map<String, Object> query) throws BusinessException;

    /**
     * 动态查询 表的数据总数（TAG_DELETE = '0'） 
     * 
     * @return
     */
    int list_tables_info_count(Map<String, Object> query) throws BusinessException;

    /**
     * 删除 
     * 
     * @return
     */
    void delete_tables_info(Map<String, Object> entity) throws BusinessException;

    /**
     * 插入 
     * 
     * @return
     */
    void insert_tables_info(Map<String, Object> entity) throws BusinessException;



    /**
     * 修改
     * @throws BusinessException
     */
    void update_tables_info(Map<String, Object> entity) throws BusinessException;
    
    /**
     * 动态查询有效记录
     * 
     * @param tokenId
     * @param tableName
     * @return
     */
    List<Map<String, Object>> list_tables(RowBounds rbonds,Map<String, Object> query) throws BusinessException;
    
    List<Map<String, Object>> list_tables(Map<String, Object> query) throws BusinessException;

    /**
     * 动态查询 表的数据总数
     * 
     * @return
     */
    int list_tables_count(Map<String, Object> query) throws BusinessException;

}
