package com.gaowj.standard.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.Status;
import com.gaowj.business.StandardBusiness;

public class actAction extends BasicAction{

	/**
	 * 
	 */
	private static final long serialVersionUID = 303797180576461148L;
	
	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonArray(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}
	
	public String insertTable() throws BusinessException{
		StandardBusiness business = BusinessManager.getBusiness(StandardBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			entity.remove("OPETYPE");
			//
			List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
			list.add(entity);
			entity.put("insertInfoList", list);
			//
			//校验是否重复
			Map<String, Object> query = new HashMap<String,Object>();
			query.put("tableName", entity.get("tableName"));
			query.put("CODE_ID", entity.get("CODE_ID"));
			int codeID_C = business.list_tables_count(query);
			if(codeID_C>0){
				jsonObject.putAll(Status.getStatusErrorMessage("编码重复!"));
				return "json";
			}
			query.remove("CODE_ID");
			query.put("CODE_NAME", entity.get("CODE_NAME"));
			int codeNAME_C = business.list_tables_count(query);
			if(codeNAME_C>0){
				jsonObject.putAll(Status.getStatusErrorMessage("名称重复!"));
				return "json";
			}
			//
		    business.insert_tables_info(entity);
		    jsonObject.putAll(Status.getStatusSuccessMessage("新增成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("新增失败!"));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String updateTable() throws BusinessException{
    	StandardBusiness business = BusinessManager.getBusiness(StandardBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			entity.remove("OPETYPE");
			//
			List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
			list.add(entity);
			entity.put("updateInfoList", list);
			
			//
		    business.update_tables_info(entity);
		    jsonObject.putAll(Status.getStatusSuccessMessage("更新成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("更新失败!"));
			e.printStackTrace();
		}
		return "json";
	}
    
   public String deleteTable() throws BusinessException{
		
	    StandardBusiness business = BusinessManager.getBusiness(StandardBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			String tableName = (String) entity.get("tableName");
			String []is_id=entity.get("CODE").toString().split("\\,");
			Map<String, Object> mapquery = new HashMap<String, Object>();
			for (String string : is_id) {
				mapquery.put("CODE_ID", string);
				mapquery.put("tableName", tableName);
		        business.delete_tables_info(mapquery);
			}
		    jsonObject.putAll(Status.getStatusSuccessMessage("删除成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败!"));
			e.printStackTrace();
		}
		return "json";
	}
   
   public String updateCacheTable() throws BusinessException{
		
	    StandardBusiness business = BusinessManager.getBusiness(StandardBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			String []is_id=entity.get("CODE").toString().split("\\,");
			Map<String, Object> mapquery = new HashMap<String, Object>();
			for (String string : is_id) {
				mapquery.put("tableName", string);
		        business.updateCache(mapquery);
			}
		    jsonObject.putAll(Status.getStatusSuccessMessage("缓存更新成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("缓存更新失败!"));
			e.printStackTrace();
		}
		return "json";
	}

}