package com.gaowj.business.system;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.exception.BusinessException;

public interface SystemBackDAO {

	/***
	 * 登陆时获取登陆人的所有可操作模块
	 */
    List<Map<String,Object>> getUserAllModule(String uCode) throws BusinessException;
    /***
	 *选取top菜单
	 */
    List<Map<String,Object>> getTopMenu(Map<String,Object> query) throws BusinessException ;
    /***
	 *获取left1级菜单
	 */
    List<Map<String,Object>> getLeftMenu1(Map<String,Object> query) throws BusinessException ;
    /***
	 *获取left2级菜单
	 */
    List<Map<String,Object>> getLeftMenu2(Map<String,Object> query) throws BusinessException ;
    /***
	 *用户信息
	 */
    List<Map<String, Object>> listLoginUserInfo(RowBounds rowbounds, Map<String, Object> query) throws BusinessException ;
    
    List<Map<String,Object>> listLoginUserInfo(Map<String,Object> query) throws BusinessException ;
    
    int listLoginUserInfoCount(Map<String, Object> query) throws BusinessException ;
    
    Map<String,Object> getMaxLoginUserCode(Map<String,Object> query) throws BusinessException ;
    
    Map<String,Object> getMaxLoginUserEmid(Map<String,Object> query) throws BusinessException ;
    
    List<Map<String, Object>> listLoginServiceUserInfo(RowBounds rowbounds, Map<String, Object> query) throws BusinessException ;
    
    List<Map<String,Object>> listLoginServiceUserInfo(Map<String,Object> query) throws BusinessException ;
    
    int listLoginServiceUserInfoCount(Map<String, Object> query) throws BusinessException ;
    /**
     * 用户增加
     */
    void insert_user(Map<String,Object> entity) throws BusinessException ;
    /**
     * 用户修改
     */
    void update_user(Map<String,Object> entity) throws BusinessException ;
    /**
     * 用户删除
     */
    void delete_user(Map<String,Object> entity) throws BusinessException ;
    
    void delete_batch_user(List<String> list) throws BusinessException ;
    /***
	 *部门信息
	 */
    List<Map<String, Object>> listDepartmentInfo(RowBounds rowbounds, Map<String, Object> query) throws BusinessException ;
    
    List<Map<String,Object>> listDepartmentInfo(Map<String,Object> query) throws BusinessException ;
    
    int listDepartmentInfoCount(Map<String, Object> query) throws BusinessException ;
    
    List<Map<String, Object>> listDepartmentSericeInfo(RowBounds rowbounds, Map<String, Object> query) throws BusinessException ;
    
    List<Map<String,Object>> listDepartmentSericeInfo(Map<String,Object> query) throws BusinessException ;
    
    int listDepartmentServiceInfoCount(Map<String, Object> query) throws BusinessException ;
    
    /**
     * 部门增加
     */
    void insert_depart(Map<String,Object> entity) throws BusinessException ;
    /**
     * 部门修改
     */
    void update_depart(Map<String,Object> entity) throws BusinessException ;
    /**
     * 部门删除
     */
    void delete_depart(Map<String,Object> entity) throws BusinessException ;
    
    /***
	 *密码修改
	 */
    void modifyPass(Map<String,Object> entity) throws BusinessException ;
    /***
	 *功能组增加
	 */
    void insert_group(Map<String,Object> entity) throws BusinessException ;
    /***
	 *功能组修改
	 */
    void update_group(Map<String,Object> entity) throws BusinessException ;
    /***
	 *功能组删除
	 */
    void delete_group(String gid) throws BusinessException ;
    /***
	 *功能组显示所有
	 */
    List<Map<String, Object>> listGroupAll(RowBounds rowbounds, Map<String, Object> query) throws BusinessException ;
	
	int listGroupAllCount(Map<String, Object> query)throws BusinessException ;
	
	List<Map<String, Object>> listGroupAll(Map<String, Object> query) throws BusinessException ;
	
	/**
	 *日志信息
	 */
    List<Map<String,Object>> listLogInfo(Map<String, Object> query) throws BusinessException ;
    
    List<Map<String, Object>> listLogInfo(RowBounds rowbounds, Map<String, Object> query)throws BusinessException ;
	
	int listLogInfoCount(Map<String, Object> query)throws BusinessException ;
	
	/**
	 * 增加日志
	 */
	void insert_log(Map<String,Object> entity) throws BusinessException ;
	
	Integer getMaxLog(Map<String, Object> query)throws BusinessException ;
	
	/**
	 *log4j日志信息
	 */
    List<Map<String,Object>> listLog4jInfo(Map<String, Object> query) throws BusinessException ;
    
    List<Map<String, Object>> listLog4jInfo(RowBounds rowbounds, Map<String, Object> query)throws BusinessException ;
	
	int listLog4jInfoCount(Map<String, Object> query)throws BusinessException ;
	
	/**
	 * 增加log4j日志
	 */
	void insert_log4j(Map<String,Object> entity) throws BusinessException ;
	
	Integer getMaxLog4j(Map<String, Object> query)throws BusinessException ;
	
	void update_log4j(Map<String,Object> entity) throws BusinessException ;
	
	/**
	 *业务操作日志信息
	 */
    List<Map<String,Object>> listLogBusiness(Map<String, Object> query) throws BusinessException ;
    
    List<Map<String, Object>> listLogBusiness(RowBounds rowbounds, Map<String, Object> query)throws BusinessException ;
	
	int listLogBusinessCount(Map<String, Object> query)throws BusinessException ;
	
	/**
	 * 增加业务操作日志
	 */
	void insert_logBusiness(Map<String,Object> entity) throws BusinessException ;

    /**
	 *模块新增
	 */
    void insert_module(Map<String,Object> entity) throws BusinessException ;

    /**
	 *模块修改
	 */
    void update_module(Map<String,Object> entity) throws BusinessException ;
    /**
	 *模块删除
	 */
    void delete_module(Map<String,Object> entity) throws BusinessException ;

    /**
	 *模块显示所有
	 */
    List<Map<String,Object>> listModule(Map<String, Object> query) throws BusinessException ;
    
    List<Map<String, Object>> listModule(RowBounds rowbounds, Map<String, Object> query)throws BusinessException ;
	
	int listModuleCount(Map<String, Object> query)throws BusinessException ;

    /**
	 *模块大类显示所有
	 */
    List<Map<String,Object>> listModuleType(Map<String, Object> query) throws BusinessException ;
    
    List<Map<String, Object>> listModuleType(RowBounds rowbounds, Map<String, Object> query)throws BusinessException ;
	
	int listModuleTypeCount(Map<String, Object> query)throws BusinessException ;

    /**
	 *模块大类新增
	 */
    void insert_moduleType(Map<String,Object> entity) throws BusinessException ;
    /**
	 *模块大类修改
	 */
    void update_moduleType(Map<String,Object> entity) throws BusinessException ;
    /**
	 *模块大类删除
	 */
    void delete_moduleType(Map<String,Object> entity) throws BusinessException ;

    /**
	 *功能组模块选定-增加
	 */
    void insert_group_c_m(Map<String,Object> entity) throws BusinessException ;
    /**
	 *功能组模块选定-删除
	 */
    void delete_group_c_m(Map<String,Object> entity) throws BusinessException ;
    /**
     * 功能组模块选定-取最大序号gm
     * 
     */
    int getMaxGm(Map<String, Object> query) throws BusinessException ;

    /**
	 *功能组模块选定-显示对应组的所有模块
	 */
     List<Map<String,Object>> listGroupM_from_G(Map<String, Object> query) throws BusinessException ;

    /**
	 *功能组人员选定-增加
	 */
    void insert_group_c_u(Map<String,Object> entity) throws BusinessException ;
    /**
	 *功能组人员选定-删除
	 */
    void delete_group_c_u(Map<String,Object> entity) throws BusinessException ;
    /**
     * 功能组模块选定-取最大序号gu
     * 
     */
    int getMaxGu(Map<String, Object> query) throws BusinessException ;

    /**
	 *功能组人员选定-显示对应组的所有人员
	 */
     List<Map<String,Object>> listGroupU_from_G(Map<String, Object> query) throws BusinessException ;

	/**
	 *人管人-显示对应管理者管理的所有人员
	 */
    List<Map<String,Object>> listPerson_from_P(Map<String, Object> query) throws BusinessException ;
    /**
     * 人管人-增加
     */
    void insert_person_p(Map<String,Object> entity) throws BusinessException ;
    /**
     * 人管人-删除
     */
    void delete_person_p(Map<String,Object> entity) throws BusinessException ;

}
