package com.gaowj.system.back;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.RequestUtils;

public class GroupChoiceLinguserAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = -34761405511659380L;
	
	private List<Map<String,Object>> OldGU;//目前选中的用户
	private List<Map<String,Object>> OldGUAll;//所有角色组选中的用户
	
	private List<String> OldGUStr=new ArrayList<String>();//目前选中的用户
	private List<String> OldGUAllStr=new ArrayList<String>();//所有角色组选中的用户
	
	private String g_name;//当前组名
	private List<Map<String,Object>> department;//所有部门
	private List<Map<String,Object>> loginuser;//所有人员
	public List<Map<String, Object>> getOldGU() {
		return OldGU;
	}
	public void setOldGU(List<Map<String, Object>> oldGU) {
		OldGU = oldGU;
	}
	public List<Map<String, Object>> getOldGUAll() {
		return OldGUAll;
	}
	public void setOldGUAll(List<Map<String, Object>> oldGUAll) {
		OldGUAll = oldGUAll;
	}
	public String getG_name() {
		return g_name;
	}
	public void setG_name(String g_name) {
		this.g_name = g_name;
	}

	public List<Map<String, Object>> getDepartment() {
		return department;
	}
	public void setDepartment(List<Map<String, Object>> department) {
		this.department = department;
	}
	public List<Map<String, Object>> getLoginuser() {
		return loginuser;
	}
	public void setLoginuser(List<Map<String, Object>> loginuser) {
		this.loginuser = loginuser;
	}
	public List<String> getOldGUStr() {
		return OldGUStr;
	}
	public void setOldGUStr(List<String> oldGUStr) {
		OldGUStr = oldGUStr;
	}
	public List<String> getOldGUAllStr() {
		return OldGUAllStr;
	}
	public void setOldGUAllStr(List<String> oldGUAllStr) {
		OldGUAllStr = oldGUAllStr;
	}
	public String execute() throws BusinessException{
		reflush();
		return SUCCESS;
	}
	
	public String save() throws BusinessException{
		String togu = RequestUtils.getString(request, "togu");
		String gid = RequestUtils.getString(request, "gid");
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		if(StringUtils.isNotEmpty(gid)){
			String[] uids= togu.split(",");
			Map<String,Object> gu = new HashMap<String,Object>();
			gu.put("G_ID", gid);
			if(StringUtils.isNotEmpty(togu)){
				systemOpeBusiness.delete_group_c_u(gu);
				for(int i=0;i<uids.length;i++){
					gu.put("U_ID", uids[i]);
					systemOpeBusiness.insert_group_c_u(gu);
				}
				
			}else{
				systemOpeBusiness.delete_group_c_u(gu);
			}
			
		}
		reflush();
		return "save";
		
	}
	
	public void reflush() throws BusinessException{
		String ls_myzd_id = RequestUtils.getString(request, RequestUtils.TABLEIDKEY);
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> query = new HashMap<String,Object>();
		if(StringUtils.isNotEmpty(ls_myzd_id)){
			OldGUAll = systemOpeBusiness.listGroupU_from_G(query);
			department = systemOpeBusiness.listDepartmentInfo(query);
			loginuser = systemOpeBusiness.listLoginUserInfo(query);
			query.put("G_ID", ls_myzd_id);
			Map<String,Object> g = systemOpeBusiness.listGroupAll(query).get(0);
			g_name = (String) g.get("G_NAME");
			OldGU = systemOpeBusiness.listGroupU_from_G(query);
			
			//
			for(Map<String,Object> u:OldGU){
              String str = u.get("CODE")+"*"+u.get("EMNAME");
              OldGUStr.add(str);
			}
			for(Map<String,Object> u:OldGUAll){
	              String str = u.get("CODE")+"*"+u.get("EMNAME");
	              OldGUAllStr.add(str);
				}
		}
		
	}

}
