package com.gaowj.system.back;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.RequestUtils;

public class GroupChoiceModuleAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = -34761405511659380L;
	
	private List<Map<String,Object>> OldGM;//目前选中的模块
	private List<Map<String,Object>> OldGMAll;//所有角色组选中的模块
	
	private List<String> OldGMStr=new ArrayList<String>();//目前选中的模块
	private List<String> OldGMAllStr=new ArrayList<String>();//所有角色组选中的模块
	
	private String g_name;//当前组名
	private List<Map<String,Object>> moduletype;//所有模块大类
	private List<Map<String,Object>> module;//所有模块
	public List<Map<String, Object>> getOldGM() {
		return OldGM;
	}
	public void setOldGM(List<Map<String, Object>> oldGM) {
		OldGM = oldGM;
	}
	public List<Map<String, Object>> getOldGMAll() {
		return OldGMAll;
	}
	public void setOldGMAll(List<Map<String, Object>> oldGMAll) {
		OldGMAll = oldGMAll;
	}
	public String getG_name() {
		return g_name;
	}
	public void setG_name(String g_name) {
		this.g_name = g_name;
	}
	public List<Map<String, Object>> getModuletype() {
		return moduletype;
	}
	public void setModuletype(List<Map<String, Object>> moduletype) {
		this.moduletype = moduletype;
	}
	public List<Map<String, Object>> getModule() {
		return module;
	}
	public void setModule(List<Map<String, Object>> module) {
		this.module = module;
	}

	public List<String> getOldGMStr() {
		return OldGMStr;
	}
	public void setOldGMStr(List<String> oldGMStr) {
		OldGMStr = oldGMStr;
	}
	public List<String> getOldGMAllStr() {
		return OldGMAllStr;
	}
	public void setOldGMAllStr(List<String> oldGMAllStr) {
		OldGMAllStr = oldGMAllStr;
	}
	public String execute() throws BusinessException{
		reflush();
		return SUCCESS;
	}
	
	public String save() throws BusinessException{
		String togm = RequestUtils.getString(request, "togm");
		String gid = RequestUtils.getString(request, "gid");
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		if(StringUtils.isNotEmpty(gid)){
			String[] mids= togm.split(",");
			Map<String,Object> gm = new HashMap<String,Object>();
			gm.put("G_ID", gid);
			if(StringUtils.isNotEmpty(togm)){
				systemOpeBusiness.delete_group_c_m(gm);
				for(int i=0;i<mids.length;i++){
					gm.put("M_ID", mids[i]);
					systemOpeBusiness.insert_group_c_m(gm);
				}
				
			}else{
				systemOpeBusiness.delete_group_c_m(gm);
			}
			
		}
		reflush();
		return "save";
		
	}
	
	public void reflush() throws BusinessException{
		String ls_myzd_id = RequestUtils.getString(request, RequestUtils.TABLEIDKEY);
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> query = new HashMap<String,Object>();
		if(StringUtils.isNotEmpty(ls_myzd_id)){
			OldGMAll = systemOpeBusiness.listGroupM_from_G(query);
			moduletype = systemOpeBusiness.listModuleType(query);
			query.put("M_STATE", 0);//获取有效的功能模块
			module = systemOpeBusiness.listModule(query);
			query.put("G_ID", ls_myzd_id);
			Map<String,Object> g = systemOpeBusiness.listGroupAll(query).get(0);
			g_name = (String) g.get("G_NAME");
			OldGM = systemOpeBusiness.listGroupM_from_G(query);
			
			//
			for(Map<String,Object> m:OldGM){
              String str = m.get("M_ID")+"*"+m.get("M_NAME");
              OldGMStr.add(str);
			}
			for(Map<String,Object> m:OldGMAll){
	              String str = m.get("M_ID")+"*"+m.get("M_NAME");
	              OldGMAllStr.add(str);
				}
		}
		
	}

}
