package com.gaowj.system.back;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.util.Encipher;

public class modifyPassAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String oldpass;
	private String newpass;
	private String renew;
	
	private String gwjURL;
	
	
	@Override
	public String execute() throws Exception {
		@SuppressWarnings("unchecked")
		Map<String,Object> u = (Map<String, Object>) request.getSession().getAttribute("userInfo");
		String ls_code=(String) u.get("CODE");
		String newPass = getpass(newpass);
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = new HashMap<String,Object>();
		entity.put("CODE",ls_code);
		entity.put("EMPASS",newPass);
    	systemOpeBusiness.modifyPass(entity);
		gwjURL="system/pages/frame/modiPass.jsp";
		this.clearMessages();
		this.addActionMessage("密码修改成功!");
		return SUCCESS;
	}
	
	public void validate(){
		
		gwjURL="system/pages/frame/modiPass.jsp";
		if(oldpass==null || oldpass.trim().length()==0){
			addFieldError("oldpass","密码不能为空!");
		}else if(!ckOldpass()){
			addFieldError("oldpass","原密码错误!");
		}
		if(newpass==null || newpass.trim().length()==0){
			addFieldError("newpass","密码不能为空!");
		}
		if(renew==null || renew.trim().length()==0){
			addFieldError("renew","密码不能为空!");
		}else if(!(renew.trim().equals(newpass))){
			addFieldError("renew","新密码核对错误!");
		}
	}
	
	public boolean ckOldpass(){
		@SuppressWarnings("unchecked")
		Map<String,Object> u = (Map<String, Object>) request.getSession().getAttribute("userInfo");
		String ls_code=(String) u.get("CODE");
		boolean tf=false;
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> query = new HashMap<String,Object>();
		query.put("CODE",ls_code);
		//query.put("EMPASS",getpass(oldpass));
		List<Map<String,Object>> oldUser = systemOpeBusiness.listLoginUserInfo(query);
		
		if(oldUser.size()>0){
			if(oldUser.get(0).get("EMPASS")!=null){
				String dataoldpass = Encipher.DecodePasswd((String)oldUser.get(0).get("EMPASS"));
				if(StringUtils.equals(dataoldpass, oldpass)){
					tf=true;
				}
			}
			
		}
		return tf;
	}
	
	public String getpass(String nopass){
		String mypass="";
		try {
			mypass=Encipher.EncodePasswd(nopass);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return mypass;
	}

	public String getOldpass() {
		return oldpass;
	}

	public void setOldpass(String oldpass) {
		this.oldpass = oldpass;
	}

	public String getNewpass() {
		return newpass;
	}

	public void setNewpass(String newpass) {
		this.newpass = newpass;
	}

	public String getRenew() {
		return renew;
	}

	public void setRenew(String renew) {
		this.renew = renew;
	}

	public String getGwjURL() {
		return gwjURL;
	}

	public void setGwjURL(String gwjURL) {
		this.gwjURL = gwjURL;
	}

}
