package com.gaowj.system.easyui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;

import net.sf.json.JSONObject;

import com.gaowj.business.SystemCacheBusiness;
import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.listener.myHttpSessionAttributeListener;
import com.gaowj.business.util.Encipher;
import com.gaowj.business.util.PropUtil;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.SessionUtil;
import com.gaowj.business.util.Status;

public class actAction  extends BasicAction{

	private static final long serialVersionUID = -7327978057007490822L;
	
	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}
	
    public String insertSysRole() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			//去除不要更新的字段
			entity.remove("OPETYPE");
			Map<String, Object> query = new HashMap<String, Object>();
			query.put("DPT_NO", entity.get("DPT_NO").toString());
			int count = business.listDepartmentInfoCount(query);
			// 编号存在
			if (count > 0) {
					jsonObject.putAll(Status.getStatusInfoMessage("部门编码重复!"));
					return "json";
			}else {
				business.insert_depart(entity);
				// 操作日志
	 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
	 				sysbusiness.insert_logBusiness("insertSysRole", "" + entity,
	 						"增加用户部门", (String) entity.get("DPT_NO"), (String) entity
	 								.get("DPT_NAME"), "SysRole");
			    //
			}
			
		    jsonObject.putAll(Status.getStatusSuccessMessage("保存成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("保存失败!"));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String updateSysRole() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			//去除不要更新的字段
			entity.remove("OPETYPE");
		    business.update_depart(entity);
		    // 操作日志
 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
 				sysbusiness.insert_logBusiness("updateSysRole", "" + entity,
 						"修改用户部门", (String) entity.get("DPT_NO"), (String) entity
 								.get("DPT_NAME"), "SysRole");
		    //
		    jsonObject.putAll(Status.getStatusSuccessMessage("更新成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("更新失败!"));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String deleteSysRole() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			String []is_id=entity.get("DPT_NO").toString().split("\\,");
			for (String string : is_id) {
				Map<String , Object>map=new HashMap<String, Object>();
				map.put("DPT_NO", string);
				business.delete_depart(map);
			}
			// 操作日志
 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
 				sysbusiness.insert_logBusiness("updateSysRole", "" + entity,
 						"删除用户部门", (String) entity.get("DPT_NO"),(String) entity.get("DPT_NO"), "SysRole");
		    //
		    jsonObject.putAll(Status.getStatusSuccessMessage("删除成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败!"));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String resetUserPass() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
    	Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
    	String t_dec = "";
		try{
			if(entity.get("USER_PWD") != null){
				entity.put("EMPASS", Encipher.EncodePasswd((String)entity.get("USER_PWD")));
				entity.remove("USER_PWD");
				t_dec="管理员修改用户密码";
				
			}
			if(entity.get("USER_PWD_RESET") != null && entity.get("USER_PWD_RESET").toString().equals("1")){
				entity.put("EMPASS", Encipher.EncodePasswd(PropUtil.getValue("userDefaultPass","quartz_service",entity.get("CODE").toString())));
				entity.remove("USER_PWD_RESET");
				t_dec="管理员重置用户密码";
			}
			business.update_user(entity);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("resetUserPass", "" + entity,t_dec, (String) entity.get("CODE"),
					(String) entity.get("EMNAME")+"("+(String) entity.get("EMID")+")","resetUserPass");
			//
		    jsonObject.putAll(Status.getStatusSuccessMessage(t_dec+"成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage(t_dec+"失败!"));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String modifyPass() throws BusinessException {

    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String, Object> entity_user = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		Map<String, Object> query = new HashMap<String, Object>();
		query.put("CODE", SessionUtil.getCode());
		List<Map<String, Object>> listData = business.listLoginUserInfo(query);
		String oldpass = (String) entity_user.get("OLDPASS");
		if (oldpass == null) {
			oldpass = "";
		}
		String newpass = (String) entity_user.get("NEWPASS");
		String againnewpass = (String) entity_user.get("AGAINNEWPASS");
		String datapass = (String) listData.get(0).get("EMPASS");
		if (StringUtils.equals(oldpass, Encipher.DecodePasswd(datapass)) == false) {
			jsonObject.putAll(Status.getStatusSuccessMessage("原密码错误!"));
		} else {
			if (StringUtils.equals(newpass, againnewpass) == false) {
				jsonObject.putAll(Status.getStatusSuccessMessage("两次输入密码不一致!"));
			} else {
				if (newpass == null) {
					newpass = "";
				}
				query.put("EMPASS", Encipher.EncodePasswd(newpass));
				try {
					business.update_user(query);
					// 操作日志
					SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
					sysbusiness.insert_logBusiness("modifyPass", "" + query,"用户密码修改", (String) query.get("CODE"),
							(String) listData.get(0).get("EMNAME")+"("+(String) listData.get(0).get("EMID")+")","modifyPass");
					//
					jsonObject.putAll(Status.getStatusSuccessMessage("用户密码修改成功!"));
				} catch (Exception e) {
					jsonObject.putAll(Status.getStatusSuccessMessage("用户密码修改失败!"));
					e.printStackTrace();
				}
			}
		}

		return "json";
	}
    
    public String insertSysUser() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			//去除不要更新的字段
			entity.remove("OPETYPE");
		    business.insert_user(entity);
		    // 操作日志
 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
 				sysbusiness.insert_logBusiness("insertSysUser", "" + entity,
 						"增加用户帐号", (String) entity.get("CODE"), (String) entity
 								.get("EMNAME"), "sysUser");
		    //
		    jsonObject.putAll(Status.getStatusSuccessMessage("保存成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("保存失败!"));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String updateSysUser() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			//去除不要更新的字段
			entity.remove("OPETYPE");
		    business.update_user(entity);
		    // 操作日志
 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
 				sysbusiness.insert_logBusiness("updateSysUser", "" + entity,
 						"修改用户帐号", (String) entity.get("CODE"), (String) entity
 								.get("EMNAME"), "sysUser");
		    //
		    jsonObject.putAll(Status.getStatusSuccessMessage("更新成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("更新失败!"));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String deleteSysUser() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			String []is_id=entity.get("CODE").toString().split("\\,");
			for (String string : is_id) {
				Map<String , Object>map=new HashMap<String, Object>();
				map.put("CODE", string);
				business.delete_user(map);
			}
			// 操作日志
 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
 				sysbusiness.insert_logBusiness("deleteSysUser", "" + entity,
 						"删除用户帐号", (String) entity.get("CODE"),(String) entity.get("CODE"), "SysUser");
		    //
			jsonObject.putAll(Status.getStatusSuccessMessage("删除成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败!"));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String insertSysGroup() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			//去除不要更新的字段
			entity.remove("OPETYPE");
		    business.insert_group(entity);
		    // 操作日志
 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
 				sysbusiness.insert_logBusiness("insertSysGroup", "" + entity,
 						"增加功能组", (String) entity.get("G_ID"), (String) entity
 								.get("G_NAME"), "SysGroup");
		    //
		    jsonObject.putAll(Status.getStatusSuccessMessage("保存成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("保存失败!"));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String updateSysGroup() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			//去除不要更新的字段
			entity.remove("OPETYPE");
			// 操作日志
 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
 				sysbusiness.insert_logBusiness("updateSysGroup", "" + entity,
 						"修改功能组", (String) entity.get("G_ID"), (String) entity
 								.get("G_NAME"), "SysGroup");
		    //
		    business.update_group(entity);
		    jsonObject.putAll(Status.getStatusSuccessMessage("更新成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("更新失败!"));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String deleteSysGroup() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			String []is_id=entity.get("G_ID").toString().split("\\,");
			for (String string : is_id) {
//				Map<String , Object>map=new HashMap<String, Object>();
//				map.put("CODE", string);
				business.delete_group(string);
			}
			// 操作日志
 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
 				sysbusiness.insert_logBusiness("deleteSysGroup", "" + entity,
 						"删除功能组", (String) entity.get("G_ID"),(String) entity.get("G_ID"), "SysGroup");
		    //
		    jsonObject.putAll(Status.getStatusSuccessMessage("删除成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败!"));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String insertSysModuletype() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			//去除不要更新的字段
			entity.remove("OPETYPE");
		    business.insert_moduleType(entity);
		    // 操作日志
 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
 				sysbusiness.insert_logBusiness("insertSysModuletype", "" + entity,
 						"增加模块大类", (String) entity.get("MT_ID"), (String) entity
 								.get("MT_NAME"), "SysModuletype");
		    //
		    jsonObject.putAll(Status.getStatusSuccessMessage("保存成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("保存失败!"));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String updateSysModuletype() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			//去除不要更新的字段
			entity.remove("OPETYPE");
		    business.update_moduleType(entity);
		    // 操作日志
 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
 				sysbusiness.insert_logBusiness("updateSysModuletype", "" + entity,
 						"修改模块大类", (String) entity.get("MT_ID"), (String) entity
 								.get("MT_NAME"), "SysModuletype");
		    //
		    jsonObject.putAll(Status.getStatusSuccessMessage("更新成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("更新失败!"));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String deleteSysModuletype() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			String []is_id=entity.get("MT_ID").toString().split("\\,");
			for (String string : is_id) {
				Map<String , Object>map=new HashMap<String, Object>();
				map.put("MT_ID", string);
				business.delete_moduleType(map);
			}
			// 操作日志
 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
 				sysbusiness.insert_logBusiness("updateSysModuletype", "" + entity,
 						"删除模块大类", (String) entity.get("MT_ID"),(String) entity.get("MT_ID"), "SysModuletype");
		    //
		    jsonObject.putAll(Status.getStatusSuccessMessage("删除成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败!"));
			e.printStackTrace();
		}
		return "json";
	}
    
public String insertSysModule() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			//去除不要更新的字段
			entity.remove("OPETYPE");
		    business.insert_module(entity);
		    // 操作日志
 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
 				sysbusiness.insert_logBusiness("insertSysModule", "" + entity,
 						"增加模块", (String) entity.get("M_ID"), (String) entity
 								.get("M_NAME"), "SysModule");
		    //
		    jsonObject.putAll(Status.getStatusSuccessMessage("保存成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("保存失败!"));
			e.printStackTrace();
		}
		return "json";
	}
	
    public String updateSysModule() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			entity = QueryParamUtil.StringToDate(entity);
			//去除不要更新的字段
			entity.remove("OPETYPE");
		    business.update_module(entity);
		    // 操作日志
 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
 				sysbusiness.insert_logBusiness("updateSysModule", "" + entity,
 						"修改模块", (String) entity.get("M_ID"), (String) entity
 								.get("M_NAME"), "SysModule");
		    //
		    jsonObject.putAll(Status.getStatusSuccessMessage("更新成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("更新失败!"));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String deleteSysModule() throws BusinessException{
		
    	SystemOpeBusiness business = BusinessManager.getBusiness(SystemOpeBusiness.class);
		String deletekey  = RequestUtils.getString(request, "deletekey");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try{
			String []is_id=entity.get("M_ID").toString().split("\\,");
			for (String string : is_id) {
				Map<String , Object>map=new HashMap<String, Object>();
				map.put("M_ID", string);
				business.delete_module(map);
			}
			// 操作日志
 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
 				sysbusiness.insert_logBusiness("updateSysModule", "" + entity,
 						"删除模块", (String) entity.get("M_ID"),(String) entity.get("M_ID"), "SysModule");
		    //
		    jsonObject.putAll(Status.getStatusSuccessMessage("删除成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败!"));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String deleteSysCacheKey() throws BusinessException{
    	Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
    	String cacheName = (String) entity.get("CACHENAME");
		String keyid = (String) entity.get("KEYID");
		SystemCacheBusiness systemCacheBusiness = BusinessManager.getBusiness(SystemCacheBusiness.class);
		
		try{
			systemCacheBusiness.removeCache(cacheName, keyid);
			// 操作日志
 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
 				sysbusiness.insert_logBusiness("deleteSysCacheKey", "" + entity,
 						"删除缓存",cacheName,keyid, "SysCacheKey");
		    //
		    jsonObject.putAll(Status.getStatusSuccessMessage("删除成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败!"));
			e.printStackTrace();
		}
		return "json";
	}
    
    public String deleteOnlineUser() throws BusinessException{
    	Map<String,Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
    	String sessionid = (String) entity.get("SESSIONID");
    	Map<String, Object> query = new HashMap<String,Object>();
    	List<Map<String, Object>> listData = myHttpSessionAttributeListener.getSessionUser(request,query);
    	HttpSession session = null;
		for(Map<String, Object> s:listData){
			String sid = (String) s.get("SESSIONID");
			if(sid.equals(sessionid)){
				session = (HttpSession) s.get("SESSIONUSER");
				break;
			}
		}
		try{
			session.setMaxInactiveInterval(0);
			// 操作日志
 			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
 				sysbusiness.insert_logBusiness("deleteOnlineUser", "" + sessionid,
 						"删除缓存",sessionid,sessionid, "OnlineUser");
		    //
		    jsonObject.putAll(Status.getStatusSuccessMessage("强制退出成功!"));
		}catch(Exception e){
			jsonObject.putAll(Status.getStatusErrorMessage("强制退出失败!"));
			e.printStackTrace();
		}
		return "json";
	}

}
