package com.gaowj.business.student;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.StudentBusiness;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;
import com.gaowj.standard.utils.CacheKit;

public class StudentBusinessImpl implements StudentBusiness {
	
	private studentDAO studentDAO;

	public studentDAO getStudentDAO() {
		return studentDAO;
	}

	public void setStudentDAO(studentDAO studentDAO) {
		this.studentDAO = studentDAO;
	}

	@Override
	public void insert_student(Map<String, Object> entity) throws BusinessException {
		if(entity.get("UUID")==null){
			entity.put("UUID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("STATUS")==null){
			entity.put("STATUS", "0");
		}
		if(entity.get("CREATE_ID")==null){
			entity.put("CREATE_ID", SessionUtil.getCode());
		}
//		if(entity.get("SAVEDAYS")==null){
//			String ls_savedays = PropUtil.getValue("set_savedays", "quartz_service", "14");
//			entity.put("SAVEDAYS", Integer.parseInt(ls_savedays));
//		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          studentDAO.insert_student(entity);
        }
	}

	@Override
	public void update_student(Map<String, Object> entity) throws BusinessException {
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("UUID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    studentDAO.update_student(entity);
		}

	}

	@Override
	public void delete_student(List<String> list) throws BusinessException {
		studentDAO.delete_student(list);
		
	}

	@Override
	public Page<Map<String, Object>> list_student(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = studentDAO.list_student(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = listCount_student(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_student(Map<String, Object> query) throws BusinessException {
		List<Map<String, Object>> list_data = CacheKit.get("ehcache10", "student"+query);
		if(list_data==null || list_data.size()==0){
			list_data=studentDAO.list_student(query);
			CacheKit.put("ehcache10", "student"+query, list_data);
		}
		return list_data;
	}

	@Override
	public int listCount_student(Map<String, Object> query) throws BusinessException {
		return studentDAO.listCount_student(query);
	}

}
